import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/sass/app.scss',  // SCSS entry
                'resources/js/app.js',      // JS entry
            ],
            refresh: true,  // Enables Laravel page reloads when Blade files change
        }),
        vue({
            template: {
                transformAssetUrls: {
                    // Fixes asset URL handling in Vue single-file components
                    base: null,
                    includeAbsolute: false,
                },
            },
        }),
    ],
    resolve: {
        alias: {
            vue: 'vue/dist/vue.esm-bundler.js',  // Required for Vue 3
            '@': '/resources/js',  // Recommended alias for cleaner imports
        },
    },
});