<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?php
            $navSettings = \App\Models\NavModel::first();
            $favicon = $navSettings && $navSettings->favicon_path 
                ? asset($navSettings->favicon_path) 
                : ($navSettings && $navSettings->logo_path 
                    ? asset($navSettings->logo_path) 
                    : asset('uploads/solutionbooths.jpg'));
        ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e($favicon); ?>">
        <title><?php echo e($navSettings->site_name ?? 'Solution Booths'); ?></title>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss']); ?>
    </head>
    <body>
        <div id="app">
            <router-view></router-view>
        </div>
    </body>

</html>
    
<script src="<?php echo e(asset('admin/plugins/jquery/jquery.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/chart.js/Chart.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/sparklines/sparkline.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/jqvmap/jquery.vmap.min.js')); ?>"></script>
<script src="<?php echo e(asset('admin/plugins/jqvmap/maps/jquery.vmap.usa.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/jquery-knob/jquery.knob.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/moment/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('admin/plugins/daterangepicker/daterangepicker.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/summernote/summernote-bs4.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>"></script>

<script src="<?php echo e(asset('admin/dist/js/adminlte.js')); ?>"></script>





<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo e(asset('frontend/lib/wow/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/lib/easing/easing.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/lib/waypoints/waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/lib/counterup/counterup.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/lib/owlcarousel/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/main.js')); ?>"></script>

<?php /**PATH E:\Solution Booths\Office Portfolio\startUp_website-main\lara-vue-project\resources\views/welcome.blade.php ENDPATH**/ ?>