<?php

use App\Http\Controllers\AboutController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CommentController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\QuoteController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\Api\FactController;
use App\Http\Controllers\ContactSettingsController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\PortfolioController;
use App\Http\Controllers\PortfolioCategoryController;
use App\Http\Controllers\NavController;
use App\Http\Controllers\MapController;
use App\Http\Controllers\PageHeaderController;
use App\Http\Controllers\FeatureController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public routes
Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::get('/list', [UserController::class, 'index'])->middleware('auth:sanctum');

// Public slider route for frontend
Route::get('/slider/public', [SliderController::class, 'publicIndex']);

// Public search route
Route::get('search', [SearchController::class, 'index']);

// Public map locations for contact page
Route::get('/maps/public/locations', [MapController::class, 'publicLocations']);
Route::get('/features/public', [FeatureController::class, 'publicIndex']);
// Publicly accessible content routes
Route::get('about', [AboutController::class, 'index']);
Route::get('about/{about}', [AboutController::class, 'show']);
Route::get('service', [ServiceController::class, 'index']);
Route::get('service/{service}', [ServiceController::class, 'show']);
Route::get('team', [TeamController::class, 'index']);
Route::get('team/{team}', [TeamController::class, 'show']);
Route::get('vendor', [VendorController::class, 'index']);
Route::get('vendor/{vendor}', [VendorController::class, 'show']);
Route::get('review', [ReviewController::class, 'index']);
Route::get('review/{review}', [ReviewController::class, 'show']);
Route::get('blog', [BlogController::class, 'index']);
Route::get('blog/{blog}', [BlogController::class, 'show']);
Route::get('portfolio', [PortfolioController::class, 'index']);
Route::get('portfolio/{portfolio}', [PortfolioController::class, 'show']);
Route::get('portfolio-categories', [PortfolioCategoryController::class, 'index']);
Route::get('portfolio-categories/{portfolio_category}', [PortfolioCategoryController::class, 'show']);
Route::get('navbar-settings', [NavController::class, 'index']);
Route::get('page-headers/{page_key}', [PageHeaderController::class, 'show']);
Route::get('facts', [FactController::class, 'index']);
Route::post('com', [CommentController::class, 'store']); // Public comments
Route::post('quote', [QuoteController::class, 'store']); // Public quotes
Route::post('email', [EmailController::class, 'store']); // Public email signups
Route::get('gn', [GeneralController::class, 'index']); // Public general settings
Route::get('/contact-settings/public', [ContactSettingsController::class, 'index']);

// Authentication protected routes
Route::middleware('auth:sanctum')->group(function () {
    // Admin CRUD routes (excluding index/show for some, or keeping all for management)
    Route::apiResource('about', AboutController::class)->except(['index', 'show']);
    Route::apiResource('service', ServiceController::class)->except(['index', 'show']);
    Route::apiResource('team', TeamController::class)->except(['index', 'show']);
    Route::apiResource('slider', SliderController::class);
    Route::apiResource('vendor', VendorController::class)->except(['index', 'show']);
    Route::apiResource('review', ReviewController::class)->except(['index', 'show']);
    Route::apiResource('quote', QuoteController::class)->except(['store']);
    Route::apiResource('contact', ContactController::class);
    Route::apiResource('blog', BlogController::class)->except(['index', 'show']);
    Route::apiResource('com', CommentController::class)->except(['store']);
    Route::apiResource('gn', GeneralController::class)->except(['index']);
    Route::apiResource('email', EmailController::class)->except(['store']);
    Route::apiResource('facts', FactController::class)->except(['index']);
    Route::apiResource('contact-settings', ContactSettingsController::class);
    Route::apiResource('portfolio', PortfolioController::class)->except(['index', 'show']);
    Route::apiResource('portfolio-categories', PortfolioCategoryController::class)->except(['index', 'show']);
    Route::apiResource('navbar-settings', NavController::class)->except(['index']);
    Route::apiResource('page-headers', PageHeaderController::class)->except(['show']);
    Route::apiResource('features', FeatureController::class);
    Route::patch('/features/{id}/toggle-status', [FeatureController::class, 'toggleStatus']);

    // Project routes
    Route::get('/projects', [ProjectController::class, 'index']);

    // Map routes with proper RESTful naming
    Route::prefix('maps')->group(function () {
        // Specific routes MUST come before parameterized routes
        Route::get('/active-locations', [MapController::class, 'activeLocations']); // For admin
        Route::patch('/sort-order', [MapController::class, 'updateSortOrder']); // Bulk sort update

        // RESTful resource routes (parameterized routes come last)
        Route::get('/', [MapController::class, 'index']);
        Route::post('/', [MapController::class, 'store']);
        Route::get('/{map}', [MapController::class, 'show']);
        Route::put('/{map}', [MapController::class, 'update']);
        Route::delete('/{map}', [MapController::class, 'destroy']);
        Route::patch('/{map}/toggle-status', [MapController::class, 'toggleStatus']);
    });
});
