<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        @php
            $navSettings = \App\Models\NavModel::first();
            $favicon = $navSettings && $navSettings->favicon_path 
                ? asset($navSettings->favicon_path) 
                : ($navSettings && $navSettings->logo_path 
                    ? asset($navSettings->logo_path) 
                    : asset('uploads/solutionbooths.jpg'));
        @endphp
        <link rel="icon" type="image/x-icon" href="{{ $favicon }}">
        <title>{{ $navSettings->site_name ?? 'Solution Booths' }}</title>
        @vite(['resources/js/app.js'])
        @vite(['resources/sass/app.scss'])
    </head>
    <body>
        <div id="app">
            <router-view></router-view>
        </div>
    </body>

</html>
    
<script src="{{asset('admin/plugins/jquery/jquery.min.js')}}"></script>

<script src="{{asset('admin/plugins/jquery-ui/jquery-ui.min.js')}}"></script>

<script src="{{asset('admin/plugins/bootstrap/js/bootstrap.bundle.min.js')}}"></script>

<script src="{{asset('admin/plugins/chart.js/Chart.min.js')}}"></script>

<script src="{{asset('admin/plugins/sparklines/sparkline.js')}}"></script>

<script src="{{asset('admin/plugins/jqvmap/jquery.vmap.min.js')}}"></script>
<script src="{{asset('admin/plugins/jqvmap/maps/jquery.vmap.usa.js')}}"></script>

<script src="{{asset('admin/plugins/jquery-knob/jquery.knob.min.js')}}"></script>

<script src="{{asset('admin/plugins/moment/moment.min.js')}}"></script>
<script src="{{asset('admin/plugins/daterangepicker/daterangepicker.js')}}"></script>

<script src="{{asset('admin/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')}}"></script>

<script src="{{asset('admin/plugins/summernote/summernote-bs4.min.js')}}"></script>

<script src="{{asset('admin/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')}}"></script>

<script src="{{asset('admin/dist/js/adminlte.js')}}"></script>




{{-- -------------Script for Frontend--------- --}}
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="{{asset('frontend/lib/wow/wow.min.js')}}"></script>
<script src="{{asset('frontend/lib/easing/easing.min.js')}}"></script>
<script src="{{asset('frontend/lib/waypoints/waypoints.min.js')}}"></script>
<script src="{{asset('frontend/lib/counterup/counterup.min.js')}}"></script>
<script src="{{asset('frontend/lib/owlcarousel/owl.carousel.min.js')}}"></script>
<script src="{{asset('frontend/js/main.js')}}"></script>
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script> --}}
