import { createRouter, createWebHistory } from "vue-router";
import store from "../store";

// Admin Components
import Dashboard from '../components/admin/Dashboard.vue';
import Login from '../components/admin/Login.vue';

// Facts Components
import ManageFacts from '../components/admin/facts/ManageFacts.vue';
import ManageFeatures from '../components/admin/features/ManageFeatures.vue';

// About Components
import About from '../components/admin/about/About.vue';
import Add_about from '../components/admin/about/Add_about.vue';
import Edit_about from '../components/admin/about/Edit_about.vue';

// Service Components
import Service from '../components/admin/service/Service.vue';
import Add_service from '../components/admin/service/Add_service.vue';
import Edit_service from '../components/admin/service/Edit_service.vue';

// Team Components
import Team from '../components/admin/team/Team.vue';
import Add_team from '../components/admin/team/Add_team.vue';
import Edit_team from '../components/admin/team/Edit_team.vue';

// Slider Components
import Slider from '../components/admin/slider/Slider.vue';

// Vendor Components
import Vendor from '../components/admin/vendor/Vendor.vue';
import Add_vendor from '../components/admin/vendor/Add_vendor.vue';

// Review Components
import Review from '../components/admin/review/Review.vue';
import Add_review from '../components/admin/review/Add_review.vue';
import Edit_review from '../components/admin/review/Edit_review.vue';

// Blog Components
import Blog from '../components/admin/blog/Blog.vue';
import Add_blog from '../components/admin/blog/Add_blog.vue';
import Edit_blog from '../components/admin/blog/Edit_blog.vue';

// General Components
import General from '../components/admin/general/General.vue';
import Add_general from '../components/admin/general/Add_general.vue';
import PageHeaders from '../components/admin/general/PageHeaders.vue';

// Other Admin Components
import Quote from '../components/admin/quote/Quote.vue';
import AdminContact from '../components/admin/contact/Contact.vue';
import Email from '../components/admin/contact/Email.vue';
import Com from '../components/admin/com/Com.vue';

// Frontend Components
import Home from '../components/frontend/Home.vue';
import Abot from '../components/frontend/About.vue';
import Serves from '../components/frontend/Serves.vue';
import Tems from '../components/frontend/Tems.vue';
import Ven from '../components/frontend/Ven.vue';
import Test from '../components/frontend/Test.vue';
import Quot from '../components/frontend/Quot.vue';
import Contact from '../components/frontend/Contact.vue';
import ContactForm from '../components/frontend/contact/ContactForm.vue'
import Blgdel from '../components/frontend/Blgdel.vue';
import Bl from '../components/frontend/Bl.vue';
import Comm from '../components/frontend/Comm.vue';
import Foot from '../components/frontend/Foot.vue';
import component from "vue-ai-carousel";

const routes = [
    // Frontend Routes (Public) - Added explicit meta.requiresAuth: false
    {
        name: 'home',
        path: '/',
        component: Home,
    },
    {
        name: 'foot',
        path: '/foot',
        component: Foot,
    },
    {
        name: 'abo',
        path: '/about',
        component: Abot,
    },
    {
        name: 'comm',
        path: '/comm',
        component: Comm,
    },
    {
        name: 'services',
        path: '/services',
        component: Serves,
    },
    {
        name: 'tem',
        path: '/tems',
        component: Tems,
    },
    {
        name: 'ven',
        path: '/ven',
        component: Ven,
    },
    {
        name: 'test',
        path: '/test',
        component: Test,
    },
    {
        name: 'quo',
        path: '/quo',
        component: Quot,
    },
    // Contact (frontend)
    {
        name: 'contact',
        path: '/contact',
        component: Contact,
    },
    {
        name: 'contact-form',
        path: '/contact-form',
        component: ContactForm,
    },
    {
        name: 'blo',
        path: '/blo/:id',
        component: Blgdel,
    },
    {
        name: 'bl',
        path: '/bl',
        component: Bl,
    },
    // Portfolio Routes
    {
        path: '/portfolio',
        name: 'portfolio',
        component: () => import('../components/frontend/Portfolio.vue'),
    },
    {
        path: '/portfolio/:category',
        name: 'portfolio-category',
        component: () => import('../components/frontend/PortfolioCategory.vue'),
        props: true
    },
    {
        path: '/portfolio/:category/project/:id',
        name: 'portfolio-project',
        component: () => import('../components/frontend/PortfolioProject.vue'),
        props: true
    },

    // Auth Routes
    {
        name: 'login',
        path: '/login',
        component: Login,
    },

    // Admin Dashboard Routes (Protected)
    {
        name: 'dashboard',
        path: '/dashboard',
        component: Dashboard,
        meta: { requiresAuth: true }
    },

    // Facts Routes (Protected)
    {
        name: 'manage-facts',
        path: '/manage-facts',
        component: ManageFacts,
        meta: { requiresAuth: true }
    },
    {
        name: 'manage-features',
        path: '/manage-features',
        component: ManageFeatures,
        meta: { requiresAuth: true }
    },

    // Navbar Settings (Protected)
    {
        path: '/navbar-settings',
        name: 'NavbarSettings',
        component: () => import('@/components/admin/nav/nav-settings.vue'),
        meta: { requiresAuth: true }
    },

    // Admin Contact Routes (Protected)
    {
        path: '/admin/contact',
        name: 'admin-contact',
        component: () => import('../components/admin/contact/Contact.vue'),
        meta: { requiresAuth: true }
    },
    {
        path: '/admin/maps',
        name: 'admin-maps',
        component: () => import('../components/admin/maps/maps.vue'),
        meta: { requiresAuth: true }
    },
    {
        path: '/admin/contact/email-subscriptions',
        name: 'email-subscriptions',
        component: () => import('../components/admin/contact/Email.vue'),
        meta: { requiresAuth: true }
    },
    {
        path: '/admin/contact/settings',
        name: 'contact-settings',
        component: () => import('../components/admin/contact/Settings.vue'),
        meta: { requiresAuth: true }
    },

    // Blog Routes (Protected)
    {
        name: 'blog',
        path: '/blog',
        component: Blog,
        meta: { requiresAuth: true }
    },
    {
        name: 'add_blog',
        path: '/adblog',
        component: Add_blog,
        meta: { requiresAuth: true }
    },
    {
        name: 'edit_blog',
        path: '/edit_blog/:id',
        component: Edit_blog,
        meta: { requiresAuth: true }
    },

    // General Routes (Protected)
    {
        name: 'gen',
        path: '/gen',
        component: General,
        meta: { requiresAuth: true }

    },
    {
        name: 'add_gen',
        path: '/adgen',
        component: Add_general,
        meta: { requiresAuth: true }

    },
    {
        name: 'page-headers',
        path: '/admin/page-headers',
        component: PageHeaders,
        meta: { requiresAuth: true }
    },

    // Review Routes (Protected)
    {
        name: 'review',
        path: '/review',
        component: Review,
        meta: { requiresAuth: true }

    },
    {
        name: 'add_review',
        path: '/adreview',
        component: Add_review,
        meta: { requiresAuth: true }

    },
    {
        name: 'edit_review',
        path: '/edit_review/:id',
        component: Edit_review,
        meta: { requiresAuth: true }

    },

    // Vendor Routes (Protected)
    {
        name: 'vendor',
        path: '/vendor',
        component: Vendor,
        meta: { requiresAuth: true }

    },
    {
        name: 'add_vendor',
        path: '/advendor',
        component: Add_vendor,
        meta: { requiresAuth: true }
    },

    // Slider Routes (Protected)
    {
        name: 'slider',
        path: '/slider',
        component: Slider,
        meta: { requiresAuth: true }
    },

    // About Routes (Protected)
    {
        name: 'admin-about',
        path: '/admin/about/about',
        component: About,
        meta: { requiresAuth: true }
    },
    {
        name: 'add_about',
        path: '/adabout',
        component: Add_about,
        meta: { requiresAuth: true }
    },
    {
        name: 'edit_about',
        path: '/edit_about/:id',
        component: Edit_about,
        meta: { requiresAuth: true }
    },

    // Portfolio Admin Routes (Protected)
    {
        path: '/portfolio/manage',
        name: 'manage-portfolio',
        component: () => import('../components/admin/portfolio/ManagePortfolio.vue'),
        meta: { requiresAuth: true }
    },
    {
        path: '/portfolio/categories',
        name: 'manage-portfolio-categories',
        component: () => import('../components/admin/portfolio/ManagePortfolioCategories.vue'),
        meta: { requiresAuth: true }
    },

    // Service Routes (Protected)
    {
        name: 'service',
        path: '/service',
        component: Service,
        meta: { requiresAuth: true }

    },
    {
        name: 'add_service',
        path: '/adservice',
        component: Add_service,
        meta: { requiresAuth: true }

    },
    {
        name: 'edit_service',
        path: '/edit_service/:id',
        component: Edit_service,
        meta: { requiresAuth: true }

    },

    // Team Routes (Protected)
    {
        name: 'team',
        path: '/team',
        component: Team,
        meta: { requiresAuth: true }
    },
    {
        name: 'add_team',
        path: '/adteam',
        component: Add_team,
        meta: { requiresAuth: true }

    },
    {
        name: 'edit_team',
        path: '/edit_team/:id',
        component: Edit_team,
        meta: { requiresAuth: true }

    },

    // Quote Route (Protected)
    {
        name: 'quote',
        path: '/quote',
        component: Quote,
        meta: { requiresAuth: true }

    },

    // Error Route (Public)
    {
        path: '/:pathMatch(.*)*',
        name: 'NotFound',
        component: () => import('@/components/errors/NotFound.vue'),

    }
];

const router = createRouter({
    history: createWebHistory(),
    routes,
    scrollBehavior(to, from, savedPosition) {
        if (savedPosition) {
            return savedPosition;
        } else {
            return { top: 0 };
        }
    }
});

// Fixed Navigation Guard - Only protect routes that explicitly require authentication
router.beforeEach(async (to, from, next) => {
    // Get authentication status from the correct namespaced store
    const isAuthenticated = store.getters['auth/isAuthenticated'];

    console.log('Router Guard - Navigating to:', to.path);
    console.log('Router Guard - Is authenticated:', isAuthenticated);
    console.log('Router Guard - Route meta:', to.meta);

    // If going to login page and already authenticated, redirect to dashboard
    if (to.meta.requiresGuest && isAuthenticated) {
        console.log('Already authenticated, redirecting to dashboard');
        next({ name: 'dashboard' });
        return;
    }

    // If route EXPLICITLY requires authentication and user is not authenticated
    if (to.meta.requiresAuth === true && !isAuthenticated) {
        console.log('Route requires auth but user not authenticated, redirecting to login');
        next({
            name: 'login',
            query: { redirect: to.fullPath }
        });
        return;
    }

    // For all other cases (including routes with requiresAuth: false or undefined), proceed normally
    console.log('Proceeding to route:', to.path);
    next();
});

export default router;