import './bootstrap';
import { createApp } from 'vue';
import App from './App.vue';
import router from './router';
import Toast from 'vue-toastification';
import 'vue-toastification/dist/index.css';
import store from './store';

async function bootstrap() {
  await store.dispatch('auth/initialize');
  
  const app = createApp(App);
  
  // Register plugins in order
  app.use(store);
  app.use(router);
  app.use(Toast, {
    timeout: 3000,
    closeOnClick: true,
    pauseOnFocusLoss: true,
    pauseOnHover: true,
    draggable: true,
    draggablePercent: 0.6,
    showCloseButtonOnHover: false,
    hideProgressBar: false,
    closeButton: 'button',
    icon: true,
    rtl: false
  });
  
  app.mount('#app');
}

bootstrap();