'use strict';var vue=require('vue');function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}var script = {
  name: 'AIcarousel',
  data: function data() {
    return {
      intervalTime: this.Property.Dlay || 5000,
      Total_CNT: null,
      screenWidth: null,
      CSL_Moving: "Moving",
      NaveBtnStyle: "PeVNCommon commonStyle",
      CounterPosition: "countPos countDefaultpos",
      CounterStyle: "CounterBtnCommon Slider_Button",
      Slider_Button_Active: "Slider_Button_Active"
    };
  },
  props: {
    /* FIRST CHECK IS THERE ANY CAROUSEL PRESENT OR NOT */
    Property: Object
  },
  mounted: function mounted() {
    var _this = this;

    /* ~~~~:~~~[ SELECT WRAPPER ELEMENT ]~~~~:~~~ */
    var SWrapper = document.getElementById(this.Property.ID);
    var CWHolder = SWrapper.firstElementChild;
    var ContentWrapper = CWHolder.firstElementChild;
    this.Total_CNT = ContentWrapper.childElementCount;
    this.screenWidth = SWrapper.clientWidth;
    /* GET PARENT-ELEMENT */

    var ParentElm = SWrapper.parentElement;
    var sectionIndex = 2; // ESSENTIAL FOR TOGGLER BUTTONS

    var InterValId = "";
    var CMD = -1; // ADDING STYLE PROPERY

    if (this.Property.NavBtn) {
      this.NaveBtnStyle = "".concat(this.Property.NavBtn, " commonStyle");
    }

    if (this.Property.CountPos) {
      this.CounterPosition = "countPos ".concat(this.Property.CountPos);
    }

    if (this.Property.CounterStyle) {
      this.CounterStyle = "CounterBtnCommon ".concat(this.Property.CounterStyle);
    }

    if (this.Property.CounterActiveStyle) {
      this.Slider_Button_Active = "".concat(this.Property.CounterActiveStyle);
    }
    /* ~~~~:~~~[ ACTION ACCORDING TO MOUSE POSTION ]~~~~:~~~ */


    SWrapper.addEventListener("mouseenter", function () {
      _this.CSL_Moving = "";
    });
    SWrapper.addEventListener("mouseleave", function () {
      _this.CSL_Moving = "Moving";
    });
    /* ~~~~:~~~[ HANDLE MOVEMENT OF CAROUSEL ]~~~~:~~~
    TRANSITION AND TRANSLETE CAROUSEL */

    ContentWrapper.addEventListener("transitionend", function () {
      if (CMD == -1) {
        ContentWrapper.appendChild(ContentWrapper.firstElementChild);
      } else if (CMD == 1) {
        ContentWrapper.prepend(ContentWrapper.lastElementChild);
      }

      ContentWrapper.style.transition = "none";
      ContentWrapper.style.transform = "translatex(".concat(0, "px)");
      setTimeout(function () {
        ContentWrapper.style.transition = "all 0.5s ease-in-out 0.5s";
        /* ECH AND EVERY CARDS TRANSITION WE UPDATE SECTION INDEX */

        sectionIndex = Number(ContentWrapper.children[1].classList[0]);
      });
      /* TOGGLER BUTTON STYLE CHANGE */

      var counterParentElm = ParentElm.children[1];

      if (counterParentElm != undefined) {
        var counterNext;
        var counterPrevious;

        if (CMD == -1) {
          var el = ContentWrapper.children[0].classList[0];
          counterNext = counterParentElm.children[el];
          counterPrevious = counterParentElm.children[el - 1];
        }

        if (CMD == 1) {
          var _el = ContentWrapper.children[1].classList[0];
          counterNext = counterParentElm.children[_el - 1];
          counterPrevious = counterParentElm.children[_el];
        }

        if (counterNext != undefined) {
          counterNext.classList.add(_this.Slider_Button_Active);
        }

        if (counterPrevious != undefined) {
          counterPrevious.classList.remove(_this.Slider_Button_Active);
        }

        if (counterNext == undefined & CMD == -1) {
          counterParentElm.lastElementChild.classList.remove(_this.Slider_Button_Active);
          counterParentElm.firstElementChild.classList.add(_this.Slider_Button_Active);
        }

        if (counterPrevious == undefined & CMD == 1) {
          counterParentElm.lastElementChild.classList.add(_this.Slider_Button_Active);
          counterParentElm.firstElementChild.classList.remove(_this.Slider_Button_Active);
        }
      }
    });
    /* 
    ~~~~:~~~[ ADJUSTING CONTENT CENTER, ACCORDING 
    TO NUMBER OF CONTENT AND SCREEN WIDTH ]~~~~:~~~
    */

    var adjustCSL = function adjustCSL() {
      var screenWidth = _this.screenWidth;
      var CWwidth = CWHolder.clientWidth;
      var CNTWidth = ContentWrapper.firstElementChild.clientWidth;
      var totalCNT = _this.Total_CNT;
      var IsTuchDown = false;
      var startX;
      /* ~~~~:~~~[ GAP BETWEEN ANY TWO CARDS ]~~~~:~~~ */

      var gap_between_CNT = (CWwidth - CNTWidth * totalCNT) / (totalCNT - 1);
      /* ~~~~:~~~[ TOTAL NUMBER/NUMBERS OF CARD/CARDS DISPLAY ON THE SCREEN ]~~~~:~~~ */

      var CNTdisplaing = Math.ceil(screenWidth / (CNTWidth + gap_between_CNT / 2));
      var xMove = (CNTdisplaing * CNTWidth + gap_between_CNT * (CNTdisplaing - 1) - screenWidth) / 2;
      var move = CNTWidth + gap_between_CNT;
      /* ~~~~:~~~[ FIRST TIME MOVE CAROUSEL ]~~~~:~~~ */

      var moveCSLfirst = function moveCSLfirst() {
        move = CNTWidth + gap_between_CNT;

        if (_this.CSL_Moving == "Moving") {
          ContentWrapper.style.transform = "translatex(".concat(-move, "px)");
          CMD = -1;
        }
      };

      var callMoveCSLfirst = function callMoveCSLfirst() {
        clearInterval(InterValId);
        InterValId = "";

        if (!InterValId) {
          InterValId = setInterval(moveCSLfirst, _this.intervalTime);
          addNevigationButton();
        }
      };
      /* 
      ~~~~:~~~[ CREATING LEFT & RIGHT MOVEMENT BUTTON ]~~~~:~~~
      [ WHEN CLICK RIGHT SIDE BUTTON CONTENT START MOVING LEFT DIRECTION ]
      [ WHEN CLICK LEFT SIDE BUTTON CONTENT START MOVING DIRECTION ]
      */


      var addNevigationButton = function addNevigationButton() {
        var NevigationButton = document.createElement("div");
        NevigationButton.className = "NavigationButtons";
        /* LEFT NAVIGATION BUTTON */

        var NVbtnPrevious = document.createElement("div");
        NVbtnPrevious.className = "Previous ".concat(_this.NaveBtnStyle);
        NVbtnPrevious.innerHTML = "&lsaquo;";
        NevigationButton.prepend(NVbtnPrevious);
        SWrapper.appendChild(NVbtnPrevious);
        NVbtnPrevious.addEventListener("click", function () {
          _this.CSL_Moving = "";

          if (CMD == -1) {
            CMD = 1;
          }

          CWHolder.style.justifyContent = "flex-start";
          ContentWrapper.style.transform = "translatex(".concat(move, "px)");
        });
        /* RIGHT NAVIGATION BUTTON */

        var NVbtnNext = document.createElement("div");
        NVbtnNext.className = "Next ".concat(_this.NaveBtnStyle);
        NVbtnNext.innerHTML = "&rsaquo;";
        NevigationButton.appendChild(NVbtnNext);
        SWrapper.appendChild(NVbtnNext);
        NVbtnNext.addEventListener("click", function () {
          CMD = -1;
          CWHolder.style.justifyContent = "flex-end";
          ContentWrapper.style.transform = "translatex(".concat(-move, "px)");
        });
      };
      /* 
      ~~~~:~~~[ CREATING MULTY TOGGLE BUTTON ]~~~~:~~~
      [ CREATE MULTIPLE TOGGLER BUTTON
       ACCORDING TO THE NUMBER OF CONTENT NUMBER]
      */


      var createMultiNavBtn = function createMultiNavBtn() {
        var counter_click = document.createElement("div");
        counter_click.className = "".concat(_this.CounterPosition);

        if (ParentElm.children.length == 1) {
          var _loop = function _loop(i) {
            var CarouselClass = ContentWrapper.children[i].classList[0];

            if (isNaN(CarouselClass) == true) {
              ContentWrapper.children[i].className = "".concat(i + 1, " ").concat(CarouselClass);
            }

            var new_div = document.createElement("div");
            new_div.innerText = i + 1;
            new_div.className = "".concat(_this.CounterStyle);
            counter_click.appendChild(new_div);

            var TranslateCards = function TranslateCards() {
              if (i + 1 - sectionIndex > 0) {
                CMD = -1;

                for (var Cno = 0; Cno < i + 1 - sectionIndex; Cno++) {
                  ContentWrapper.appendChild(ContentWrapper.children[0]);
                }

                sectionIndex = i + 1;
              }

              if (i + 1 - sectionIndex < 0) {
                CMD = 1;

                for (var _Cno = 0; _Cno < sectionIndex - (i + 1); _Cno++) {
                  ContentWrapper.prepend(ContentWrapper.children[totalCNT - 1]);
                }

                sectionIndex = i + 1;
              }

              if (i + 1 - sectionIndex == 0) {
                return false;
              }
            };
            /* WHEN CLICK NUMBER TOGGLER BUTTONS */


            new_div.addEventListener("click", function () {
              _this.CSL_Moving = "";
              counter_click.children[sectionIndex - 1].classList.remove(_this.Slider_Button_Active);
              new_div.classList.add(_this.Slider_Button_Active);
              TranslateCards();
              setTimeout(function () {
                _this.CSL_Moving = "Moving";
              }, 2 * _this.intervalTime);
            });
          };

          /* CREATING COUNTER CLICKABLE BUTTONS */
          for (var i = 0; i < totalCNT; i++) {
            _loop(i);
          }

          if (totalCNT > 2) {
            ParentElm.appendChild(counter_click);
          }
        }
      };
      /* ~~~~:~~~[ ACTION ACCORDING TO SCREEN TOUCH ]~~~~:~~~ */

      /* WHEN TOUCH START */


      SWrapper.addEventListener("touchstart", function (e) {
        IsTuchDown = true;
        _this.CSL_Moving = "";
        var touch = e.touches[0];
        startX = touch.pageX - SWrapper.offsetLeft;
      }, {
        passive: true
      });
      /* WHEN TOUCH MOVE */

      SWrapper.addEventListener("touchmove", function (e) {
        _this.CSL_Moving = "";
        if (!IsTuchDown) return;
        var touch = e.touches[0];
        var x = touch.pageX - SWrapper.offsetLeft;
        var slidMove = x - startX;

        if (CWwidth > screenWidth) {
          if (slidMove < -(CNTWidth / 2)) {
            CWHolder.style.justifyContent = "flex-start";
            ContentWrapper.style.transform = "translatex(".concat(-move, "px)");
            CMD = -1;
          }

          if (slidMove > CNTWidth / 2) {
            CWHolder.style.justifyContent = "flex-end";
            ContentWrapper.style.transform = "translatex(".concat(move, "px)");
            CMD = 1;
          }
        }
      }, {
        passive: true
      });
      /* WHEN TOUCH END */

      SWrapper.addEventListener("touchend", function () {
        IsTuchDown = false;
        _this.CSL_Moving = "Moving";
      }, {
        passive: true
      });
      /* ~~~~:~~~[ POSTIONING CAROUSEL ]~~~~:~~~ */

      /* WHEN SCREEN WIDTH IS LESSTHAN CONTENT WIDTH 
      CALL FIRST TIME CAROUSEL MOVEMENT FUNCTION*/

      if (CWwidth > screenWidth) {
        CWHolder.style.transform = "translatex(".concat(-xMove, "px)");
        callMoveCSLfirst();
        createMultiNavBtn();
      }
      /* WHEN SCREEN WIDTH GRATERTHAN CONTENT WIDTH REMOVE INTERVAL 
      & CENTER ALL CONTENT */


      if (CWwidth <= screenWidth) {
        /* REMOVE LEFT & RIGHT NEVIGATION BUTTON */
        if (SWrapper.children.length > 1) {
          SWrapper.removeChild(SWrapper.children[1]);
          SWrapper.removeChild(SWrapper.children[1]);
        }
        /* REMOVE TOGGLER NAVIGATION BUTTONS */


        if (totalCNT > 2 & ParentElm.children[1] != undefined) {
          ParentElm.removeChild(ParentElm.children[1]);
        }

        clearInterval(InterValId);
        CWHolder.style.transform = "none";
        ContentWrapper.style.transform = "none";
        CWHolder.style.justifyContent = "center";
      }
      /* CONTENT NUMBER GRATERTHAN '2' THEN WE CALL THS FUNCTION */


      if (CNTdisplaing == 2 & totalCNT >= 2 & screenWidth <= 2 * CNTWidth) {
        move = CNTWidth - (screenWidth - CNTWidth) / 2 + gap_between_CNT;
        CWHolder.style.transform = "translatex(".concat(-move, "px)");
        callMoveCSLfirst();
      }
    };
    /* 
    IF CONTENT NUMBER NOT ZERO THEN WE CALL CAROUSEL POSTION ADJUST FUNCTION 
    */


    if (this.Total_CNT != 0) {
      adjustCSL();
    }
    /* ~~~~:~~~[ AFTER 200ms CHAKE CONTENT SITUATION ]~~~~:~~~ */


    var contentOBSERVER = function contentOBSERVER() {
      var New_Total_CNT = ContentWrapper.childElementCount;
      /* CHECK CONTENT UPDATE OR IS THERE ANY NEW CONTENT ADDED */

      if (_this.Total_CNT != New_Total_CNT) {
        _this.Total_CNT = New_Total_CNT;

        if (_this.Total_CNT != 0) {
          adjustCSL();
        }
      }
      /* CHECK CHECK SCREEN WITH CHANGE OR NOT */


      var New_screenWidth = SWrapper.clientWidth;

      if (_this.screenWidth != New_screenWidth) {
        _this.screenWidth = New_screenWidth;

        if (_this.Total_CNT != 0) {
          adjustCSL();
        }
      }
      /* REMOVE LEFT & RIGHT NEVIGATION BUTTON FOR SMALL SCREEN */


      if (_this.screenWidth <= 420) {
        if (SWrapper.children.length > 1) {
          SWrapper.removeChild(SWrapper.children[1]);
          SWrapper.removeChild(SWrapper.children[1]);
        }
      }

      window.requestAnimationFrame(contentOBSERVER);
    };

    window.requestAnimationFrame(contentOBSERVER);
  }
};var _hoisted_1 = {
  class: "iP3kL1jB2xC1eH5oU3eD9bZ1h ATAOTASHolder"
};
var _hoisted_2 = ["id"];
var _hoisted_3 = {
  class: "vR2lC1dN2bD1xN1vB3rD1hF1d"
};
var _hoisted_4 = {
  class: "lC3oC2kE3bD2fB1jC2qB4eF1v"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createElementBlock("div", _hoisted_1, [vue.createElementVNode("div", {
    id: $props.Property.ID,
    class: "hH6bF5bC7dM2dF4iB1eJ1eD4k"
  }, [vue.createElementVNode("div", _hoisted_3, [vue.createElementVNode("div", _hoisted_4, [vue.renderSlot(_ctx.$slots, "default")])])], 8, _hoisted_2)]);
}function styleInject(css, ref) {
  if ( ref === void 0 ) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') { return; }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}var css_248z = "\n/* SLIDER HOLDER */\n.iP3kL1jB2xC1eH5oU3eD9bZ1h{\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n}\n/* SLIDER WRAPPER \n[IT WRAP THE CONTENT ACCORDING TO REQUIREMENT ]*/\n.hH6bF5bC7dM2dF4iB1eJ1eD4k{\n    height: auto;\n    width: 100%;\n    display: grid;\n    grid-template-columns: auto;\n    overflow: hidden;\n    position: relative;\n    cursor: pointer;\n}\n\n/* CONTENT WRAPPER HOLDER */\n.vR2lC1dN2bD1xN1vB3rD1hF1d{\n    width: auto;\n    height: auto;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background-color: transparent;\n}\n/* CONTENT WRAPPER */\n.lC3oC2kE3bD2fB1jC2qB4eF1v{\n    width: auto;\n    min-height: 1.5rem;\n    display: flex;\n    overflow: hidden;\n    padding: 0;\n    background-color: transparent;\n    transition: all 0.5s ease-in-out 0.5s;\n}\n/* BSIC STYLING OF CONTENT WE CAN OVERRIGHT IT */\n.lC3oC2kE3bD2fB1jC2qB4eF1v div{\n    width: 15rem;\n    height: 10rem;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    font-size: 40px;\n    font-weight: bold;\n    color: #009b5a;\n    background-color: #d3faff;\n    margin: 0 5px;\n    position: relative;\n    z-index: 1;\n    border-radius: 5%;\n    margin: 5px;\n}\n/* FIRST CONTENT  */\n.lC3oC2kE3bD2fB1jC2qB4eF1v div:first-child{\n    margin-left: 0;\n}\n/* LAST CONTENT */\n.lC3oC2kE3bD2fB1jC2qB4eF1v div:last-child{\n    margin-right: 0;\n}\n\n/* LEFT RIGHT NEVIGATION BUTTONS */\n.commonStyle{\n    position: absolute;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    text-align: center;\n}\n.PeVNCommon{\n    top: 45%;\n    font-size: 2.5rem;\n    font-weight: bolder;\n    color: #302f2fe8;\n    height: 2rem;\n    width: 2rem;\n    background-color: #ffffff8a;\n    border-radius: 50%;\n    text-shadow: 0 0 3px #fff, 0 0 5px #fff;\n}\n.hH6bF5bC7dM2dF4iB1eJ1eD4k .Previous{\n    left: 0;\n}\n.hH6bF5bC7dM2dF4iB1eJ1eD4k .Next{\n    right: 0;\n}\n/* CIRCULAR NAVIGATION BUTTONS  */\n.countPos{\n    width: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background-color: transparent;\n    cursor: pointer;\n}\n.countDefaultpos{\n    height: 1.25rem;\n    margin-top: -1.7rem;\n    padding-bottom: 0.5rem;\n}\n.CounterBtnCommon{\n    display: flex;\n    text-align: center;\n    align-items: center;\n    justify-content: center;\n    margin: 2px;\n    box-sizing: border-box;\n    margin-top: 2.5px;\n    margin-bottom: 5px;\n    position: relative;\n}\n.Slider_Button{\n    height: 1rem;\n    width: 1rem;\n    background: #a5a5a5;\n    border-radius: 50%;\n    font-size: 0.6rem;\n    font-weight: bolder;\n    color: #ffffff;\n    transition: 1s;\n}\n.Slider_Button_Active{\n    background: #16011f;\n    border: 0.1rem solid #000000;\n    color: #ffffff;\n}\n";
styleInject(css_248z);script.render = render;// Import vue component
// IIFE injects install function into component, allowing component
// to be registered via Vue.use() as well as Vue.component(),

var component = /*#__PURE__*/(function () {
  // Get component instance
  var installable = script; // Attach install function executed by Vue.use()

  installable.install = function (app) {
    app.component('VueAIcarousel', installable);
  };

  return installable;
})(); // It's possible to expose named exports when writing components that can
// also be used as directives, etc. - eg. import { RollupDemoDirective } from 'rollup-demo';
// export const RollupDemoDirective = directive;
var namedExports=/*#__PURE__*/Object.freeze({__proto__:null,'default':component});// only expose one global var, with named exports exposed as properties of
// that global var (eg. plugin.namedExport)

Object.entries(namedExports).forEach(function (_ref) {
  var _ref2 = _slicedToArray(_ref, 2),
      exportName = _ref2[0],
      exported = _ref2[1];

  if (exportName !== 'default') component[exportName] = exported;
});module.exports=component;