import {
  createBaseVNode,
  createElementBlock,
  openBlock,
  renderSlot
} from "./chunk-2TUSPKX7.js";
import "./chunk-SSYGV25P.js";

// node_modules/vue-ai-carousel/dist/VueAIcarousel.esm.js
var script = {
  name: "AIcarousel",
  data() {
    return {
      intervalTime: this.Property.Dlay || 5e3,
      Total_CNT: null,
      screenWidth: null,
      CSL_Moving: "Moving",
      NaveBtnStyle: "PeVNCommon commonStyle",
      CounterPosition: "countPos countDefaultpos",
      CounterStyle: "CounterBtnCommon Slider_Button",
      Slider_Button_Active: "Slider_Button_Active"
    };
  },
  props: {
    /* FIRST CHECK IS THERE ANY CAROUSEL PRESENT OR NOT */
    Property: Object
  },
  mounted() {
    let SWrapper = document.getElementById(this.Property.ID);
    let CWHolder = SWrapper.firstElementChild;
    let ContentWrapper = CWHolder.firstElementChild;
    this.Total_CNT = ContentWrapper.childElementCount;
    this.screenWidth = SWrapper.clientWidth;
    let ParentElm = SWrapper.parentElement;
    let sectionIndex = 2;
    let InterValId = "";
    let CMD = -1;
    if (this.Property.NavBtn) {
      this.NaveBtnStyle = `${this.Property.NavBtn} commonStyle`;
    }
    if (this.Property.CountPos) {
      this.CounterPosition = `countPos ${this.Property.CountPos}`;
    }
    if (this.Property.CounterStyle) {
      this.CounterStyle = `CounterBtnCommon ${this.Property.CounterStyle}`;
    }
    if (this.Property.CounterActiveStyle) {
      this.Slider_Button_Active = `${this.Property.CounterActiveStyle}`;
    }
    SWrapper.addEventListener("mouseenter", () => {
      this.CSL_Moving = "";
    });
    SWrapper.addEventListener("mouseleave", () => {
      this.CSL_Moving = "Moving";
    });
    ContentWrapper.addEventListener("transitionend", () => {
      if (CMD == -1) {
        ContentWrapper.appendChild(ContentWrapper.firstElementChild);
      } else if (CMD == 1) {
        ContentWrapper.prepend(ContentWrapper.lastElementChild);
      }
      ContentWrapper.style.transition = "none";
      ContentWrapper.style.transform = `translatex(${0}px)`;
      setTimeout(() => {
        ContentWrapper.style.transition = "all 0.5s ease-in-out 0.5s";
        sectionIndex = Number(ContentWrapper.children[1].classList[0]);
      });
      let counterParentElm = ParentElm.children[1];
      if (counterParentElm != void 0) {
        let counterNext;
        let counterPrevious;
        if (CMD == -1) {
          let el = ContentWrapper.children[0].classList[0];
          counterNext = counterParentElm.children[el];
          counterPrevious = counterParentElm.children[el - 1];
        }
        if (CMD == 1) {
          let el = ContentWrapper.children[1].classList[0];
          counterNext = counterParentElm.children[el - 1];
          counterPrevious = counterParentElm.children[el];
        }
        if (counterNext != void 0) {
          counterNext.classList.add(this.Slider_Button_Active);
        }
        if (counterPrevious != void 0) {
          counterPrevious.classList.remove(this.Slider_Button_Active);
        }
        if (counterNext == void 0 & CMD == -1) {
          counterParentElm.lastElementChild.classList.remove(this.Slider_Button_Active);
          counterParentElm.firstElementChild.classList.add(this.Slider_Button_Active);
        }
        if (counterPrevious == void 0 & CMD == 1) {
          counterParentElm.lastElementChild.classList.add(this.Slider_Button_Active);
          counterParentElm.firstElementChild.classList.remove(this.Slider_Button_Active);
        }
      }
    });
    const adjustCSL = () => {
      let screenWidth = this.screenWidth;
      let CWwidth = CWHolder.clientWidth;
      let CNTWidth = ContentWrapper.firstElementChild.clientWidth;
      let totalCNT = this.Total_CNT;
      let IsTuchDown = false;
      let startX;
      let gap_between_CNT = (CWwidth - CNTWidth * totalCNT) / (totalCNT - 1);
      let CNTdisplaing = Math.ceil(screenWidth / (CNTWidth + gap_between_CNT / 2));
      let xMove = (CNTdisplaing * CNTWidth + gap_between_CNT * (CNTdisplaing - 1) - screenWidth) / 2;
      let move = CNTWidth + gap_between_CNT;
      const moveCSLfirst = () => {
        move = CNTWidth + gap_between_CNT;
        if (this.CSL_Moving == "Moving") {
          ContentWrapper.style.transform = `translatex(${-move}px)`;
          CMD = -1;
        }
      };
      const callMoveCSLfirst = () => {
        clearInterval(InterValId);
        InterValId = "";
        if (!InterValId) {
          InterValId = setInterval(moveCSLfirst, this.intervalTime);
          addNevigationButton();
        }
      };
      const addNevigationButton = () => {
        let NevigationButton = document.createElement("div");
        NevigationButton.className = "NavigationButtons";
        let NVbtnPrevious = document.createElement("div");
        NVbtnPrevious.className = `Previous ${this.NaveBtnStyle}`;
        NVbtnPrevious.innerHTML = "&lsaquo;";
        NevigationButton.prepend(NVbtnPrevious);
        SWrapper.appendChild(NVbtnPrevious);
        NVbtnPrevious.addEventListener("click", () => {
          this.CSL_Moving = "";
          if (CMD == -1) {
            CMD = 1;
          }
          CWHolder.style.justifyContent = "flex-start";
          ContentWrapper.style.transform = `translatex(${move}px)`;
        });
        let NVbtnNext = document.createElement("div");
        NVbtnNext.className = `Next ${this.NaveBtnStyle}`;
        NVbtnNext.innerHTML = "&rsaquo;";
        NevigationButton.appendChild(NVbtnNext);
        SWrapper.appendChild(NVbtnNext);
        NVbtnNext.addEventListener("click", () => {
          CMD = -1;
          CWHolder.style.justifyContent = "flex-end";
          ContentWrapper.style.transform = `translatex(${-move}px)`;
        });
      };
      const createMultiNavBtn = () => {
        let counter_click = document.createElement("div");
        counter_click.className = `${this.CounterPosition}`;
        if (ParentElm.children.length == 1) {
          for (let i = 0; i < totalCNT; i++) {
            let CarouselClass = ContentWrapper.children[i].classList[0];
            if (isNaN(CarouselClass) == true) {
              ContentWrapper.children[i].className = `${i + 1} ${CarouselClass}`;
            }
            let new_div = document.createElement("div");
            new_div.innerText = i + 1;
            new_div.className = `${this.CounterStyle}`;
            counter_click.appendChild(new_div);
            const TranslateCards = () => {
              if (i + 1 - sectionIndex > 0) {
                CMD = -1;
                for (let Cno = 0; Cno < i + 1 - sectionIndex; Cno++) {
                  ContentWrapper.appendChild(ContentWrapper.children[0]);
                }
                sectionIndex = i + 1;
              }
              if (i + 1 - sectionIndex < 0) {
                CMD = 1;
                for (let Cno = 0; Cno < sectionIndex - (i + 1); Cno++) {
                  ContentWrapper.prepend(ContentWrapper.children[totalCNT - 1]);
                }
                sectionIndex = i + 1;
              }
              if (i + 1 - sectionIndex == 0) {
                return false;
              }
            };
            new_div.addEventListener("click", () => {
              this.CSL_Moving = "";
              counter_click.children[sectionIndex - 1].classList.remove(this.Slider_Button_Active);
              new_div.classList.add(this.Slider_Button_Active);
              TranslateCards();
              setTimeout(() => {
                this.CSL_Moving = "Moving";
              }, 2 * this.intervalTime);
            });
          }
          if (totalCNT > 2) {
            ParentElm.appendChild(counter_click);
          }
        }
      };
      SWrapper.addEventListener("touchstart", (e) => {
        IsTuchDown = true;
        this.CSL_Moving = "";
        let touch = e.touches[0];
        startX = touch.pageX - SWrapper.offsetLeft;
      }, {
        passive: true
      });
      SWrapper.addEventListener("touchmove", (e) => {
        this.CSL_Moving = "";
        if (!IsTuchDown)
          return;
        let touch = e.touches[0];
        const x = touch.pageX - SWrapper.offsetLeft;
        const slidMove = x - startX;
        if (CWwidth > screenWidth) {
          if (slidMove < -(CNTWidth / 2)) {
            CWHolder.style.justifyContent = "flex-start";
            ContentWrapper.style.transform = `translatex(${-move}px)`;
            CMD = -1;
          }
          if (slidMove > CNTWidth / 2) {
            CWHolder.style.justifyContent = "flex-end";
            ContentWrapper.style.transform = `translatex(${move}px)`;
            CMD = 1;
          }
        }
      }, {
        passive: true
      });
      SWrapper.addEventListener("touchend", () => {
        IsTuchDown = false;
        this.CSL_Moving = "Moving";
      }, {
        passive: true
      });
      if (CWwidth > screenWidth) {
        CWHolder.style.transform = `translatex(${-xMove}px)`;
        callMoveCSLfirst();
        createMultiNavBtn();
      }
      if (CWwidth <= screenWidth) {
        if (SWrapper.children.length > 1) {
          SWrapper.removeChild(SWrapper.children[1]);
          SWrapper.removeChild(SWrapper.children[1]);
        }
        if (totalCNT > 2 & ParentElm.children[1] != void 0) {
          ParentElm.removeChild(ParentElm.children[1]);
        }
        clearInterval(InterValId);
        CWHolder.style.transform = `none`;
        ContentWrapper.style.transform = `none`;
        CWHolder.style.justifyContent = "center";
      }
      if (CNTdisplaing == 2 & totalCNT >= 2 & screenWidth <= 2 * CNTWidth) {
        move = CNTWidth - (screenWidth - CNTWidth) / 2 + gap_between_CNT;
        CWHolder.style.transform = `translatex(${-move}px)`;
        callMoveCSLfirst();
      }
    };
    if (this.Total_CNT != 0) {
      adjustCSL();
    }
    const contentOBSERVER = () => {
      let New_Total_CNT = ContentWrapper.childElementCount;
      if (this.Total_CNT != New_Total_CNT) {
        this.Total_CNT = New_Total_CNT;
        if (this.Total_CNT != 0) {
          adjustCSL();
        }
      }
      let New_screenWidth = SWrapper.clientWidth;
      if (this.screenWidth != New_screenWidth) {
        this.screenWidth = New_screenWidth;
        if (this.Total_CNT != 0) {
          adjustCSL();
        }
      }
      if (this.screenWidth <= 420) {
        if (SWrapper.children.length > 1) {
          SWrapper.removeChild(SWrapper.children[1]);
          SWrapper.removeChild(SWrapper.children[1]);
        }
      }
      window.requestAnimationFrame(contentOBSERVER);
    };
    window.requestAnimationFrame(contentOBSERVER);
  }
};
var _hoisted_1 = {
  class: "iP3kL1jB2xC1eH5oU3eD9bZ1h ATAOTASHolder"
};
var _hoisted_2 = ["id"];
var _hoisted_3 = {
  class: "vR2lC1dN2bD1xN1vB3rD1hF1d"
};
var _hoisted_4 = {
  class: "lC3oC2kE3bD2fB1jC2qB4eF1v"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", _hoisted_1, [createBaseVNode("div", {
    id: $props.Property.ID,
    class: "hH6bF5bC7dM2dF4iB1eJ1eD4k"
  }, [createBaseVNode("div", _hoisted_3, [createBaseVNode("div", _hoisted_4, [renderSlot(_ctx.$slots, "default")])])], 8, _hoisted_2)]);
}
function styleInject(css, ref) {
  if (ref === void 0)
    ref = {};
  var insertAt = ref.insertAt;
  if (!css || typeof document === "undefined") {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z = "\n/* SLIDER HOLDER */\n.iP3kL1jB2xC1eH5oU3eD9bZ1h{\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n}\n/* SLIDER WRAPPER \n[IT WRAP THE CONTENT ACCORDING TO REQUIREMENT ]*/\n.hH6bF5bC7dM2dF4iB1eJ1eD4k{\n    height: auto;\n    width: 100%;\n    display: grid;\n    grid-template-columns: auto;\n    overflow: hidden;\n    position: relative;\n    cursor: pointer;\n}\n\n/* CONTENT WRAPPER HOLDER */\n.vR2lC1dN2bD1xN1vB3rD1hF1d{\n    width: auto;\n    height: auto;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background-color: transparent;\n}\n/* CONTENT WRAPPER */\n.lC3oC2kE3bD2fB1jC2qB4eF1v{\n    width: auto;\n    min-height: 1.5rem;\n    display: flex;\n    overflow: hidden;\n    padding: 0;\n    background-color: transparent;\n    transition: all 0.5s ease-in-out 0.5s;\n}\n/* BSIC STYLING OF CONTENT WE CAN OVERRIGHT IT */\n.lC3oC2kE3bD2fB1jC2qB4eF1v div{\n    width: 15rem;\n    height: 10rem;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    font-size: 40px;\n    font-weight: bold;\n    color: #009b5a;\n    background-color: #d3faff;\n    margin: 0 5px;\n    position: relative;\n    z-index: 1;\n    border-radius: 5%;\n    margin: 5px;\n}\n/* FIRST CONTENT  */\n.lC3oC2kE3bD2fB1jC2qB4eF1v div:first-child{\n    margin-left: 0;\n}\n/* LAST CONTENT */\n.lC3oC2kE3bD2fB1jC2qB4eF1v div:last-child{\n    margin-right: 0;\n}\n\n/* LEFT RIGHT NEVIGATION BUTTONS */\n.commonStyle{\n    position: absolute;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    text-align: center;\n}\n.PeVNCommon{\n    top: 45%;\n    font-size: 2.5rem;\n    font-weight: bolder;\n    color: #302f2fe8;\n    height: 2rem;\n    width: 2rem;\n    background-color: #ffffff8a;\n    border-radius: 50%;\n    text-shadow: 0 0 3px #fff, 0 0 5px #fff;\n}\n.hH6bF5bC7dM2dF4iB1eJ1eD4k .Previous{\n    left: 0;\n}\n.hH6bF5bC7dM2dF4iB1eJ1eD4k .Next{\n    right: 0;\n}\n/* CIRCULAR NAVIGATION BUTTONS  */\n.countPos{\n    width: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background-color: transparent;\n    cursor: pointer;\n}\n.countDefaultpos{\n    height: 1.25rem;\n    margin-top: -1.7rem;\n    padding-bottom: 0.5rem;\n}\n.CounterBtnCommon{\n    display: flex;\n    text-align: center;\n    align-items: center;\n    justify-content: center;\n    margin: 2px;\n    box-sizing: border-box;\n    margin-top: 2.5px;\n    margin-bottom: 5px;\n    position: relative;\n}\n.Slider_Button{\n    height: 1rem;\n    width: 1rem;\n    background: #a5a5a5;\n    border-radius: 50%;\n    font-size: 0.6rem;\n    font-weight: bolder;\n    color: #ffffff;\n    transition: 1s;\n}\n.Slider_Button_Active{\n    background: #16011f;\n    border: 0.1rem solid #000000;\n    color: #ffffff;\n}\n";
styleInject(css_248z);
script.render = render;
var entry_esm = (() => {
  const installable = script;
  installable.install = (app) => {
    app.component("VueAIcarousel", installable);
  };
  return installable;
})();
export {
  entry_esm as default
};
//# sourceMappingURL=vue-ai-carousel.js.map
