<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Feature;

class FeatureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $features = [
            [
                'title' => 'Best In Industry',
                'description' => 'We have the highest levels of technical expertise and accreditations to resolve your issues, but we also have a genuine passion for understanding your organisation',
                'icon' => 'fa fa-cubes',
                'status' => 'Active'
            ],
            [
                'title' => 'Award Winning',
                'description' => 'We have the highest levels of technical expertise and accreditations to resolve your issues, but we also have a genuine passion for understanding your organisation',
                'icon' => 'fa fa-award',
                'status' => 'Active'
            ],
            [
                'title' => 'Professional Staff',
                'description' => 'We have the highest levels of technical expertise and accreditations to resolve your issues, but we also have a genuine passion for understanding your organisation',
                'icon' => 'fa fa-users-cog',
                'status' => 'Active'
            ],
            [
                'title' => '24/7 Support',
                'description' => 'We have the highest levels of technical expertise and accreditations to resolve your issues, but we also have a genuine passion for understanding your organisation',
                'icon' => 'fa fa-phone-alt',
                'status' => 'Active'
            ]
        ];

        foreach ($features as $feature) {
            Feature::create($feature);
        }
    }
}
