<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('navbar_settings_table', function (Blueprint $table) {
            $table->string('bg_color')->default('#ffffff')->after('logo_path');
            $table->string('text_color')->default('#000000')->after('bg_color');
            $table->boolean('is_sticky')->default(true)->after('text_color');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('navbar_settings_table', function (Blueprint $table) {
            $table->dropColumn(['bg_color', 'text_color', 'is_sticky']);
        });
    }
};
