<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PortfolioCategory extends Model
{
    protected $fillable = [
        'name', 
        'slug', 
        'icon',
        'description',
        'order', 
        'image'
    ];

    public function portfolios(): HasMany
    {
        return $this->hasMany(Portfolio::class);
    }

    protected static function booted()
    {
        static::deleting(function ($category) {
            if ($category->portfolios()->count() > 0) {
                throw new \Exception("Cannot delete category with associated portfolios.");
            }
        });
    }
}