<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class Portfolio extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'image',
        'short_description',
        'long_description',
        'link',
        'client',
        'technologies',
        'category_id',
        'is_featured',
        'is_active',
    ];
    public function category(): BelongsTo
    {
        return $this->belongsTo(PortfolioCategory::class);
    }
}
