<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use Illuminate\Http\Request;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource for public access
     */
    public function publicIndex()
    {
        $slider = Slider::orderBy('created_at', 'desc')->get();
        return response()->json(['success' => true, 'data' => $slider, 'message' => 'Slides fetched successfully']);
    }

    /**
     * Display a listing of the resource for admin
     */
    public function index()
    {
        $slider = Slider::orderBy('created_at', 'desc')->get();
        return response()->json(['success' => true, 'data' => $slider, 'message' => 'Slides fetched successfully']);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'details' => 'required|string',
            'file' => 'required|image|mimes:jpeg,png,jpg,gif,webp|max:2048'
        ]);

        $fileName = time() . '_' . $request->file->getClientOriginalName();
        $request->file->move(public_path('uploads/'), $fileName);

        $data = Slider::create([
            'title' => $request->input('title'),
            'details' => $request->input('details'),
            'photo' => $fileName,
        ]);     
        
        return response()->json([
            'success' => true,
            'data' => $data,
            'message' => 'Slide created successfully!',
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $data = Slider::findOrFail($id);
        return response()->json(['success' => true, 'data' => $data, 'message' => 'Slide fetched successfully!']);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'details' => 'required|string',
            'file' => 'sometimes|image|mimes:jpeg,png,jpg,gif,webp|max:2048'
        ]);

        $slide = Slider::findOrFail($id);
        
        $data = [
            'title' => $request->input('title'),
            'details' => $request->input('details'),
        ];

        if ($request->hasFile('file')) {
            // Delete old file if it exists
            if ($slide->photo && file_exists(public_path('uploads/' . $slide->photo))) {
                unlink(public_path('uploads/' . $slide->photo));
            }
            
            $fileName = time() . '_' . $request->file->getClientOriginalName();
            $request->file->move(public_path('uploads/'), $fileName);
            $data['photo'] = $fileName;
        }

        $slide->update($data);
        
        return response()->json([
            'success' => true,
            'data' => $slide,
            'message' => 'Slide updated successfully!',
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $slide = Slider::findOrFail($id);
        
        // Delete associated file
        if ($slide->photo && file_exists(public_path('uploads/' . $slide->photo))) {
            unlink(public_path('uploads/' . $slide->photo));
        }
        
        $slide->delete();
        
        return response()->json([
            'success' => true, 
            'message' => 'Slide deleted successfully'
        ]);
    }
}