<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PageHeader;

class PageHeaderController extends Controller
{
    public function index()
    {
        $headers = PageHeader::all();
        return response()->json(['success' => true, 'data' => $headers]);
    }

    public function show($page_key)
    {
        $header = PageHeader::where('page_key', $page_key)->first();
        return response()->json(['success' => true, 'data' => $header]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'page_key' => 'required|string|unique:page_headers',
            'title' => 'nullable|string',
            'subtitle' => 'nullable|string',
            'button_text' => 'nullable|string',
            'button_link' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        $data = $request->only(['page_key', 'title', 'subtitle', 'button_text', 'button_link']);

        if ($request->hasFile('image')) {
            $imageName = time() . '.' . $request->image->extension();
            $request->image->move(public_path('uploads'), $imageName);
            $data['image'] = $imageName;
        }

        $header = PageHeader::create($data);
        return response()->json(['success' => true, 'data' => $header]);
    }

    public function update(Request $request, $id)
    {
        $header = PageHeader::findOrFail($id);

        $request->validate([
            'page_key' => 'required|string|unique:page_headers,page_key,' . $header->id,
            'title' => 'nullable|string',
            'subtitle' => 'nullable|string',
            'button_text' => 'nullable|string',
            'button_link' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        $data = $request->only(['page_key', 'title', 'subtitle', 'button_text', 'button_link']);

        if ($request->hasFile('image')) {
            if ($header->image && file_exists(public_path('uploads/' . $header->image))) {
                unlink(public_path('uploads/' . $header->image));
            }
            $imageName = time() . '.' . $request->image->extension();
            $request->image->move(public_path('uploads'), $imageName);
            $data['image'] = $imageName;
        }

        $header->update($data);
        return response()->json(['success' => true, 'data' => $header]);
    }

    public function destroy($id)
    {
        $header = PageHeader::findOrFail($id);
        if ($header->image && file_exists(public_path('uploads/' . $header->image))) {
            unlink(public_path('uploads/' . $header->image));
        }
        $header->delete();
        return response()->json(['success' => true, 'message' => 'Deleted successfully']);
    }
}
