<?php

// app/Http/Controllers/NavController.php
namespace App\Http\Controllers;

use App\Models\NavModel;
use Illuminate\Http\Request;

class NavController extends Controller
{
    public function index()
    {
        return NavModel::firstOrCreate([]);
    }

    public function update(Request $request)
    {
        $settings = NavModel::firstOrCreate([]);

        $validated = $request->validate([
            'site_name' => 'required|string|max:255',
            'logo' => 'sometimes|image|mimes:jpeg,png,jpg,svg|max:2048',
            'favicon' => 'sometimes|image|mimes:jpeg,png,jpg,ico,svg|max:1024',
            'bg_color' => 'sometimes|string|max:7',
            'text_color' => 'sometimes|string|max:7',
            'is_sticky' => 'sometimes|boolean'
        ]);

        if ($request->hasFile('logo')) {
            $path = $request->file('logo')->store('public/logos');
            $validated['logo_path'] = str_replace('public/', 'storage/', $path);
        }

        if ($request->hasFile('favicon')) {
            $path = $request->file('favicon')->store('public/favicons');
            $validated['favicon_path'] = str_replace('public/', 'storage/', $path);
        }

        $settings->update($validated);

        return $settings;
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'site_name' => 'required|string|max:255',
            'logo' => 'sometimes|image|mimes:jpeg,png,jpg,svg|max:2048',
            'favicon' => 'sometimes|image|mimes:jpeg,png,jpg,ico,svg|max:1024',
            'bg_color' => 'sometimes|string|max:7',
            'text_color' => 'sometimes|string|max:7',
            'is_sticky' => 'sometimes|boolean'
        ]);

        if ($request->hasFile('logo')) {
            $path = $request->file('logo')->store('public/logos');
            $validated['logo_path'] = str_replace('public/', 'storage/', $path);
        }

        if ($request->hasFile('favicon')) {
            $path = $request->file('favicon')->store('public/favicons');
            $validated['favicon_path'] = str_replace('public/', 'storage/', $path);
        }

        $settings = NavModel::create($validated);

        return $settings;
    }
}
