<?php

namespace App\Http\Controllers;

use App\Models\Feature;
use Illuminate\Http\Request;

class FeatureController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $features = Feature::all();
        return response()->json($features);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string',
            'icon' => 'required|string',
            'description' => 'required|string',
            'status' => 'required|string',
        ]);

        $feature = Feature::create($request->all());
        return response()->json(['success' => true, 'data' => $feature]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Feature $feature)
    {
        return response()->json(['success' => true, 'data' => $feature]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Feature $feature)
    {
        $request->validate([
            'title' => 'required|string',
            'icon' => 'required|string',
            'description' => 'required|string',
            'status' => 'required|string',
        ]);

        $feature->update($request->all());
        return response()->json(['success' => true, 'data' => $feature]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Feature $feature)
    {
        $feature->delete();
        return response()->json(['success' => true, 'message' => 'Deleted successfully']);
    }

    /**
     * Public index for frontend
     */
    public function publicIndex()
    {
        $features = Feature::where('status', 'Active')->get();
        return response()->json(['success' => true, 'data' => $features]);
    }

    /**
     * Toggle status
     */
    public function toggleStatus(Request $request, $id)
    {
        $feature = Feature::findOrFail($id);
        $feature->update(['status' => $request->status]);
        return response()->json(['success' => true]);
    }
}
