<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactSetting; // If using a dedicated model

class ContactSettingsController extends Controller
{
    // Get current settings
    public function index()
    {
        $settings = ContactSetting::first();
        if (!$settings) {
            return response()->json([
                'contact_email' => '',
                'notification_email' => '',
                'email_prefix' => '[Contact Form]',
                'phone' => '',
                'address' => ''
            ]);
        }
        return response()->json($settings);
    }

    // Save new settings
    public function store(Request $request)
    {
        $validated = $request->validate([
            'contact_email' => 'required|email',
            'notification_email' => 'required|email',
            'email_prefix' => 'required|string|max:50',
            'phone' => 'nullable|string|max:20',
            'address' => 'nullable|string|max:255'
        ]);

        $settings = ContactSetting::updateOrCreate(['id' => 1], $validated);

        return response()->json(['message' => 'Settings saved successfully', 'data' => $settings]);
    }
}
