<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Fact;
use Illuminate\Http\Request;

class FactController extends Controller
{
    // Get all facts
    public function index()
    {
        $facts = Fact::all();
        return response()->json($facts);
    }

    // Create a new fact
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'count' => 'required|integer',
            'icon' => 'required|string',
            'status' => 'nullable|string',
        ]);

        $fact = Fact::create($request->all());
        return response()->json($fact, 201);
    }

    // Get a single fact
    public function show(Fact $fact)
    {
        return response()->json($fact);
    }

    // Update a fact
    public function update(Request $request, Fact $fact)
    {
        $request->validate([
            'title' => 'sometimes|string|max:255',
            'count' => 'sometimes|integer',
            'icon' => 'sometimes|string',
            'status' => 'sometimes|string',
        ]);

        $fact->update($request->all());
        return response()->json($fact);
    }

    // Delete a fact
    public function destroy(Fact $fact)
    {
        $fact->delete();
        return response()->noContent();
    }
}