# StartUp Portfolio & Multi-Service Website

A high-performance startup website built with **Laravel 10** and **Vue.js 3**. This project features a dynamic administrative dashboard, a premium frontend design with smooth animations, and a categorized portfolio management system.

## 🚀 Key Features

- **Smooth Hero Slider**: Enhanced transitions with premium timing for an elegant first impression.
- **Dynamic Portfolio**: 
  - **Featured Carousel**: Showcase selected projects in a stylish carousel.
  - **Categorized View**: Projects are automatically grouped by categories with intuitive navigation.
- **Admin Dashboard**: Full CRUD for sliders, facts, services, testimonials, and portfolio projects.
- **Smart Homepage**: Reorganized layout for better user conversion (Slider -> Featured Projects -> Testimonials).
- **Interactive Elements**: Real-time factual counters, client testimonials, and a functional contact system.
- **Responsive Design**: Fully optimized for Desktop, Tablet, and Mobile views.

## 🛠️ Tech Stack

- **Backend**: Laravel 10 (PHP 8+)
- **Frontend**: Vue.js 3, Bootstrap 5, Vanilla CSS
- **Database**: MySQL / PostgreSQL
- **Animations**: Animate.css, Owl Carousel, WOW.js

## 📦 Installation

1. **Clone the repository**:
   ```bash
   git clone <repository-url>
   cd lara-vue-project
   ```

2. **Install PHP dependencies**:
   ```bash
   composer install
   ```

3. **Install JavaScript dependencies**:
   ```bash
   npm install
   ```

4. **Environment Configuration**:
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```
   *Configure your database settings in the `.env` file.*

5. **Run Migrations**:
   ```bash
   php artisan migrate
   ```

6. **Storage Link**:
   ```bash
   php artisan storage:link
   ```

## 🏃 Running the Application

1. **Start the Laravel server**:
   ```bash
   php artisan serve
   ```

2. **Start the Vite development server**:
   ```bash
   npm run dev
   ```

3. Open your browser and navigate to `http://localhost:8000`.

## 🖥️ Dashboard Access

Access the administrative dashboard at `/admin`.
*Ensure you have created an admin user or use the default provided credentials.*

## 🌟 Recent Updates (Jan 2026)

- **UI Smoothing**: Slider transitions updated from 0.8s to 1.5s with `cubic-bezier` for a "harsh-free" experience.
- **Homepage Makeover**: Reordered sections to prioritize "Featured Projects" immediately after the hero section.
- **Portfolio Overhaul**: New categorized rendering logic and featured project carousel implementation.

---
Developed with ❤️ by the StartUp Team.
